/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/* ---------------------------------------------------------------
 * File: xri.h 
 *       Requester-Initiator (RI) function prototypes
 * -----------------------------------------------------------------*/

#ifndef XRI_H_INCLUDED
#define XRI_H_INCLUDED

#include <xridefs.h>

#ifdef __cplusplus
extern "C" {
#endif


/********************************************************************
  RI programming ************************************************
 ********************************************************************/

CLI bx_errtype EXPORT BestXRIProg(            /* @riprog */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXRIRead(            /* @riread */
  bx_handletype  handle,
  bx_int32 option
);

/********************************************************************
  RI generics *******************************************************
 *******************************************************************/

CLI bx_errtype EXPORT BestXRIGenDefaultSet(   /* @rigendefset */
  bx_handletype handle
);

CLI bx_errtype EXPORT BestXRIGenGet(          /* @rigenget */
  bx_handletype        handle,
  bx_rigentype          prop,                     
  bx_int32             *val                   /* #RETURN "0x%08lx" */
);
  
CLI bx_errtype EXPORT BestXRIGenSet(          /* @rigenset */
  bx_handletype        handle,
  bx_rigentype          prop,                      
  bx_int32             val                       
);

CLI bx_errtype EXPORT BestXRIGenProg(          /* @rigenprog */
  bx_handletype        handle
);

CLI bx_errtype EXPORT BestXRIGenRead(          /* @rigenread */
  bx_handletype        handle
);

/********************************************************************
  RI block **********************************************************
 *******************************************************************/

CLI  bx_errtype EXPORT BestXRIBlockMemInit(     /* @riblkmeminit */     
  bx_handletype handle
);

CLI  bx_errtype EXPORT BestXRIBlockDefaultSet(  /* @riblkdefset */
  bx_handletype  handle,
  bx_int32       offset
);

CLI bx_errtype EXPORT BestXRIBlockGet(          /* @riblkget */
  bx_handletype  handle,
  bx_int32       offset,
  bx_riblktype    prop,                                  
  bx_int32       *val                           /* #RETURN "0x%08lx" */
);

CLI  bx_errtype EXPORT BestXRIBlockSet(         /* @riblkset */
  bx_handletype  handle,
  bx_int32       offset,
  bx_riblktype    prop,                                  
  bx_int32       val                                    
);

CLI bx_errtype EXPORT BestXRIBlockProg(         /* @riblkprog */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXRIBlockRead(         /* @riblkread */
  bx_handletype  handle,
  bx_int32 option
);

CLI bx_errtype EXPORT BestXRIBlockCopyLine(     /* @riblkcopyline */
  bx_handletype  handle,
  bx_int32 srcline,
  bx_int32 destline
);


/********************************************************************
  RI Behavior ***************************************************
 *******************************************************************/

CLI  bx_errtype EXPORT BestXRIBehMemInit(           /* @ribehmeminit */
  bx_handletype handle
);

CLI  bx_errtype EXPORT BestXRIBehDefaultSet(        /* @ribehdefset */
  bx_handletype handle,
  bx_int32 offset
);

CLI bx_errtype EXPORT BestXRIBehSet(                /* @ribehset */
  bx_handletype handle,
  bx_int32 offset,
  bx_ribehtype prop,                                     
  bx_int32 val                                          
);

CLI  bx_errtype EXPORT BestXRIBehGet(               /* @ribehget */
  bx_handletype handle,
  bx_int32 offset,
  bx_ribehtype prop,                                     
  bx_int32   *val                                       /* #RETURN "0x%08lx" */
);

CLI bx_errtype EXPORT BestXRIBehProg(               /* @ribehprog */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXRIBehRead(               /* @ribehread */
  bx_handletype  handle,
  bx_int32 option
);

CLI bx_errtype EXPORT BestXRIBehCopyLine(     /* @ribehcopyline */
  bx_handletype  handle,
  bx_int32 srcline,
  bx_int32 destline
);

#ifdef __cplusplus
}
#endif

#endif
